function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 116);

T = GK_financial.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(108) = getPowerDeriv(T(8),1-params(6),2);
T(109) = T(56)*T(108);
T(110) = (-((-(T(54)*y(100)))*(y(33)+y(33))))/(y(33)*y(33)*y(33)*y(33));
T(111) = (-T(54))/(y(33)*y(33));
T(112) = getPowerDeriv(y(104),params(5),2);
T(113) = getPowerDeriv(T(23),1-params(5),2);
T(114) = getPowerDeriv(y(44)*y(50),params(2),2);
T(115) = getPowerDeriv(T(38),1-params(4),2);
T(116) = (y(71)-(y(72)+y(69)*y(73)))*(-y(69))+(y(71)-(y(72)+y(69)*y(73)))*(-y(69));

end
